// priority: 22

let 开启调试日志 = false;

let 维度限制日志 = (日志内容) => {
    if (开启调试日志) {
        console.log("[维度限制调试]", 日志内容);
    }
};

let 个人击杀数据键 = "kubejs_personal_kill_counts";
let 全局击杀数据键 = "kubejs_global_kill_counts";
let 维度提示冷却标记键 = "dimension_denial_cooldown";

EntityEvents.death(e => {
    let 伤害源 = e.source;
    if (!伤害源 || !伤害源.player) {
        return;
    }

    let 击杀者 = 伤害源.player;
    let s = e.server;
    let pDATA = 击杀者.persistentData;
    let sDATA = s.persistentData;
    let 生物ID = e.entity.type;
    维度限制日志(`击杀事件: p "${击杀者.displayName.string}" 击杀了 "${生物ID}"`);

    for (let 维度ID in 维度进入限制配置) {
        let 规则 = 维度进入限制配置[维度ID];
        if (规则.所需击杀列表 && 规则.所需击杀列表[生物ID]) {
            维度限制日志(`维度 "${维度ID}" 规则关心此生物的死亡。`);
            let 先前是否满足 = 检查击杀是否满足(击杀者, 规则);
            
            if (规则.击杀条件范围 === "个人") {
                let 击杀数据 = pDATA.getCompound(个人击杀数据键);
                let 当前击杀数 = 击杀数据.getInt(生物ID);
                击杀数据.putInt(生物ID, 当前击杀数 + 1);
                pDATA.put(个人击杀数据键, 击杀数据);
                维度限制日志(`更新个人击杀数: "${生物ID}" -> ${当前击杀数 + 1}`);
            } else if (规则.击杀条件范围 === "全服") {
                let 击杀数据 = sDATA.getCompound(全局击杀数据键);
                let 当前击杀数 = 击杀数据.getInt(生物ID);
                击杀数据.putInt(生物ID, 当前击杀数 + 1);
                sDATA.put(全局击杀数据键, 击杀数据);
                维度限制日志(`更新全服击杀数: "${生物ID}" -> ${当前击杀数 + 1}`);
            }
            
            let 现在是否满足 = 检查击杀是否满足(击杀者, 规则);
            if (现在是否满足 && !先前是否满足 && 规则.提示信息_满足击杀条件) {
                击杀者.tell(Component.of(规则.提示信息_满足击杀条件));
                维度限制日志(`p "${击杀者.displayName.string}" 满足了维度 "${维度ID}" 的击杀条件，已发送提示。`);
            }
        }
    }
});

function 检查阶段是否满足(p, 阶段列表) {
    if (!阶段列表 || 阶段列表.length === 0) return true;
    for (let 阶段ID of 阶段列表) {
        if (!p.stages.has(阶段ID)) return false;
    }
    return true;
}

function 检查进度是否完成(p, 进度列表, s) {
    if (!进度列表 || 进度列表.length === 0) return true;
    let 玩家进度管理器 = p.getAdvancements();
    for (let 进度ID of 进度列表) {
        let 进度资源位置 = new $资源位置(进度ID);
        let 进度对象 = s.getAdvancements().getAdvancement(进度资源位置);
        if (!进度对象) {
            console.error(`[配置错误] 找不到ID为 "${进度ID}" 的进度！`);
            return false;
        }
        if (!玩家进度管理器.getOrStartProgress(进度对象).isDone()) return false;
    }
    return true;
}

function 检查击杀是否满足(p, 规则) {
    let 所需击杀 = 规则.所需击杀列表;
    if (!所需击杀 || Object.keys(所需击杀).length === 0) return true;

    let 击杀数据;
    if (规则.击杀条件范围 === "个人") {
        let pDATA = p.persistentData;
        击杀数据 = pDATA.getCompound(个人击杀数据键);
    } else if (规则.击杀条件范围 === "全服") {
        let sDATA = p.server.persistentData;
        击杀数据 = sDATA.getCompound(全局击杀数据键);
    } else {
        return true;
    }

    for (let 生物ID in 所需击杀) {
        let 需要数量 = 所需击杀[生物ID];
        if (击杀数据.getInt(生物ID) < 需要数量) {
            return false;
        }
    }
    return true;
}

NativeEvents.onEvent(Java.loadClass("net.minecraftforge.event.entity.EntityTravelToDimensionEvent"), e => {
    let 实体 = e.getEntity();
    if (!(实体 instanceof $服务器玩家)) {
        return;
    }

    let p = 实体;
    let s = p.server;
    let 目标维度资源键 = e.getDimension();
    let 目标维度ID = 目标维度资源键.location().toString();

    if (维度进入限制配置.hasOwnProperty(目标维度ID)) {
        
        if (p.isCreative() || p.isSpectator()) {
            维度限制日志(`玩家 "${p.displayName.string}" 是创造/观察者模式，已放行。`);
            return;
        }
        维度限制日志(`玩家 "${p.displayName.string}" 尝试进入受限维度 "${目标维度ID}"`);
        let 规则 = 维度进入限制配置[目标维度ID];
        let 允许进入 = false;
        let 阶段满足 = 检查阶段是否满足(p, 规则.所需阶段列表);
        let 进度满足 = 检查进度是否完成(p, 规则.所需进度列表, s);
        let 击杀满足 = 检查击杀是否满足(p, 规则);
        维度限制日志(`条件检查结果: 阶段=${阶段满足}, 进度=${进度满足}, 击杀=${击杀满足}`);

        switch (规则.逻辑类型) {
            case "与":
                允许进入 = 阶段满足 && 进度满足 && 击杀满足;
                break;
            case "或":
                let 有阶段 = 规则.所需阶段列表 && 规则.所需阶段列表.length > 0;
                let 有进度 = 规则.所需进度列表 && 规则.所需进度列表.length > 0;
                let 有击杀 = 规则.所需击杀列表 && Object.keys(规则.所需击杀列表).length > 0;
                允许进入 = (!有阶段 && !有进度 && !有击杀) || (有阶段 && 阶段满足) || (有进度 && 进度满足) || (有击杀 && 击杀满足);
                break;
            case "仅阶段":
                允许进入 = 阶段满足;
                break;
            case "仅进度":
                允许进入 = 进度满足;
                break;
            case "仅击杀":
                允许进入 = 击杀满足;
                break;
            default:
                console.warn(`[配置警告] 维度 "${目标维度ID}" 的逻辑类型 "${规则.逻辑类型}" 无效。`);
                允许进入 = false;
        }
        维度限制日志(`最终判定: ${允许进入 ? "允许" : "阻止"} 进入。`);

        if (!允许进入) {
            let pDATA = p.persistentData;
            let 当前时间 = p.level.time;
            let 上次提示时间 = pDATA.getLong(维度提示冷却标记键) || 0;

            if (当前时间 - 上次提示时间 > 60) {
                 p.tell(Component.of(规则.提示信息_未满足));
                pDATA.putLong(维度提示冷却标记键, 当前时间);
                维度限制日志(`已向玩家 "${p.displayName.string}" 发送拒绝进入提示, 并设置冷却。`);
            }
            e.setCanceled(true);
        }
    }
});